IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_SCA_Importar_Accesos_Externos') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_SCA_Importar_Accesos_Externos
END
GO

CREATE PROCEDURE dbo.CPJ_SCA_Importar_Accesos_Externos @pJsonRecibido VARCHAR(MAX)
AS
SET NOCOUNT ON

	/***************************************************************************************************

	Procedimiento:      CPJ_SCA_Importar_Accesos_Externos
	Fecha de Creacion:  2024-11-19
	Creado por:         Adriana Laverde
	Descripcion:        Importación de datos de controles de accesos externos 
	Llamado por:        
	Tablas afectadas:    
	Usado en:           
	Parametro(s):       FlagUsarTrans, ModoDebug
	Forma de uso:       EXEC CPJ_SCA_Importar_Accesos_Externos '{"FlagUsarTrans":"0","ModoDebug":"0"}'
	Notas adicionales:  

	****************************************************************************************************

	SUMARIO DE CAMBIOS
	FECHA(yyyy-mm-dd)    Autor              Comentarios
	------------------- ------------------- ------------------------------------------------------------

              
	***************************************************************************************************/

/*Variables recibidas por parametro a traves del JSON*/
DECLARE	@pFlagUsarTrans			TINYINT,
		@pModoDebug				TINYINT,
		@pId_Lista_Evento		SMALLINT,
		@pTipo					CHAR(1),
		@pFecha					DATETIME,
		@pCredencial			VARCHAR(100),
		@pObservacion			VARCHAR(2000),
		@pId_Lista_Precio		INT

SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)
SET @pTipo					= ISNULL(CONVERT(CHAR(1), dbo.CF_JSON_VALUE(@pJsonRecibido,'Tipo')),'')
SET @pFecha					= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha')),'')
SET @pCredencial			= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJsonRecibido,'Credencial')),'')
SET @pObservacion			= ISNULL(CONVERT(VARCHAR(2000), dbo.CF_JSON_VALUE(@pJsonRecibido,'Observacion')),'')
SET @pId_Lista_Precio		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Lista_Precio')),0)
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored						INT
DECLARE @rtaMsjStored						VARCHAR(4000)
DECLARE @JSON_Parametros_Stored_Invocado	VARCHAR(8000)
DECLARE @rta_JSON_Stored_Invocado			VARCHAR(8000)
DECLARE @Result_Stored_Invocado				INT
DECLARE @Result_Tabla_Stored_Invocado		TABLE (ErrorNumber	INT,
											ErrorSeverity	INT,
											ErrorState		INT,
											ErrorProcedure  VARCHAR(1000),
											ErrorLine		INT,
											ErrorMessage	VARCHAR(4000))
DECLARE @json								VARCHAR(8000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion Variables Locales*/
DECLARE @Id_Cliente							INT
/*Fin de Declaraciones Variables Locales */

BEGIN TRY
	IF (@pFlagUsarTrans <> 0)
	BEGIN
		BEGIN TRAN
	END

	IF (@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_SCA_Importar_Accesos_Externos'
		PRINT 'Parametros: '+ @pJsonRecibido  
		PRINT ' ---------------------- '
	END

	SET @Id_Cliente = ISNULL(
		(SELECT TOP 1 Id_Cliente 
		 FROM (
			 SELECT Id_Cliente 
			 FROM Clientes 
			 WHERE ACTIVO = 1 AND (Credencial_Nro = @pCredencial OR CONVERT(VARCHAR(100),Doc_Nro) = @pCredencial)
			 UNION ALL
			 SELECT Id_Cliente 
			 FROM Clientes_Links 
			 WHERE Url = @pCredencial OR Token = @pCredencial
		 ) AS Cliente),
		0
	)

	IF (@pModoDebug = 1)
	BEGIN
		PRINT 'Id_Cliente: '+ CONVERT(VARCHAR(14),@Id_Cliente)
		PRINT ' ---------------------- '
	END 

	IF (@Id_Cliente > 0)
	BEGIN

		INSERT INTO Cd_Es (Tipo, Origen, Id_Cliente, Id_Tarjeta, Fecha, Observacion, Id_Controlador_Paso_Permitido)
				   VALUES (@pTipo, 'E', @Id_Cliente, @pCredencial, @pFecha,  @pObservacion, @pId_Lista_Precio)

	END

	/*========================================================= RESULTADO =======================================================================================*/

	IF (@Id_Cliente = 0)
	BEGIN
		SELECT 	  5000 AS ErrorNumber
					,0 AS ErrorSeverity
					,0 AS ErrorState
					,0 AS ErrorProcedure
					,0 AS ErrorLine
					,'No existe cód. de socio para la credencial ingresada' AS ErrorMessage
	END


		SELECT 		 0 AS ErrorNumber
					,0 AS ErrorSeverity
					,0 AS ErrorState
					,0 AS ErrorProcedure
					,0 AS ErrorLine
					,'Datos ingresados correctamente' AS ErrorMessage

	
	/*====================================================================================================================================================*/

	IF @pFlagUsarTrans <> 0 COMMIT
	
	/*====================================================================================================================================================*/

	IF (@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_SCA_Importar_Accesos_Externos'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 